/**
* \file: demoscene.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Simple scene for demo application.
*
* \component: osgStream
*
* \author: Jens Georg <jgeorg@de.adit-jv.com>
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
***********************************************************************/

#ifndef DEMOSCENE_H
#define DEMOSCENE_H

#include <osg/Node>
#include <osg/MatrixTransform>
#include <osg/AnimationPath>

class DemoScene : public osg::Group
{
public:
    DemoScene(std::string str);
    ~DemoScene() {}
private:
    osg::AnimationPathCallback *createAnimationCallbackPath(float radius, float time);
    osg::Node *createObject(const std::string &filename, const osg::Vec4 &color);
    osg::MatrixTransform *createStaticNode(const osg::Vec3 &center, osg::Node *child);
    osg::MatrixTransform *createAnimateNode(const osg::Vec3 &center, float radius, float time, osg::Node *child);
    void init(std::string str);
};

#endif // DEMOSCENE_H
